let aguila = require('common/aguila');

module.exports = {

  create: function(aon, title) {

    // throw JSON.stringify(arguments);
    let result = {};
    result.widget = aguila.create(aon);
    if (result.widget) {
      result.items = this.items(result.widget, this.names(aon));
      if (title) this.title(result.widget, title);
    }
    return result;
  },
  
  names: function(aon, more) {
    
    let names = [];
    
    function getName(aon) {
      
      if (aon && typeof(aon) === 'object') {
        
        // found named leave
        if (aon.type) {
          if (aon.name) {
            names.push(aon.name);
          }
        }
        
        if (aon.items) {
          
          // found items
          aon.items.forEach( item => {
            getName(item);
          });
          
        } else {
          
          // anything else ...
          Object.keys(aon).forEach( key => {
            getName(aon[key]);
          });
        }
      }
    }
    
    getName(aon);    
    return names;
  },
  
  items: function(widget, names) {

    let items = {};
    names.forEach( item => {
      let down = widget.down(item);
      if (down) items[item] = down;
    });
    return items;
  },
  
  open: function(type, _opts) {
    
    let opts = Object.assign({}, _opts);
    aguila.enter(() => {
      let widget = aguila.create({
        type: type,
      }).popup({
        title: opts.title || ''
      });
    });
  },
  
  title: function(widget, title) {
    
    setImmediate(() => {
      if (widget)
        widget.title = '';
    });
    setImmediate(() => {
      if (widget && widget.form)
        widget.form.title = title;
    });

  }
  
  
};
